# Config Syntax

for any config, its structure should be

```xml
<config>
    <device type="SNMP Device">
        <mibObj oid=".1.3.6.1.2.1.1.1" name="sysDescr" instance="systemInfo" direct="1"/>
        <mibObj oid=".1.3.6.1.2.1.2.2.1.1" name="ifIndex" instance="interface" index="true"/>
        <mibObj oid=".1.3.6.1.2.1.2.2.1.3" name="ifType" instance="interface" >
            <map str="ethernetCsmacd" value="6" />
        </mibObj>
    </device>
</config>
```

these tags and attributes mean

- `config`: config tag
- `device`: a device
    - `type`: device type
    - `sysObjectId`: system oid of the device
    - `abstract`: this device is a generic device
    - `parent`: the device that inherit form
- `mibObj`: a mib object, it's an oid and its properties
    - `oid`: oid number, for send snmp
    - `name`: oid name, for identify this oid
    - `instance`: the table that oid belongs, it will be used for get-next
    - `index`: specify this oid is an index of this table
    - `direct`: poll this oid by get cmd rather than get-next cmd, if table has a direct mibObj, this table will be poll by get cmd.
    - `overwrite`: overwite this inherited value
    - `omit`: don't poll this inherited value
    - `max`: max value of this oid
- `map`: map of oid num value and customized string
    - `str`: the string that be transmitted by mq
    - `value`: original oid value