BEGIN;
CREATE SEQUENCE IF NOT EXISTS public.mq_user_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;

CREATE TABLE IF NOT EXISTS public.mq_users (
	id INT PRIMARY KEY DEFAULT NEXTVAL('public.mq_user_id_seq'::regclass),
	username VARCHAR(32) NOT NULL,
	password VARCHAR(140) NOT NULL,
    status SMALLINT NOT NULL,
	created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW(),
    updated_at TIMESTAMP WITH TIME ZONE DEFAULT NOW()
);


INSERT INTO mq_users (id, username, password, status)
SELECT NEXTVAL('public.mq_user_id_seq'::regclass), 'mxviewInternal', 'PBKDF2$sha512$100000$jW1AB9Cr1CqIYsDHx5bh6w==$LGts44uvVJWa/wL3Z1cOU1mnarnFBd2Yg99LL2QMDSd3fPAsNwG2VKzPow1vsfM1tK5QqWHwKRTJnM1uDAhy2Q==',1
WHERE NOT EXISTS(
    SELECT 1 FROM public.mq_users WHERE username = 'mxviewInternal'
);

INSERT INTO mq_users (id, username, password, status)
SELECT NEXTVAL('public.mq_user_id_seq'::regclass), 'mxviewGateway', 'PBKDF2$sha512$100000$TPehH5TD/ytWcXM0gTBwow==$RXpuTH4jUYfewXaLnGClPMZvAmFi2eO2WOUGcdkL+UKUOk5HfdxsEqsef0hNJOaiqzGC6GP4oi/S4EzC8/at5A==',1
WHERE NOT EXISTS(
    SELECT 1 FROM public.mq_users WHERE username = 'mxviewGateway'
);
COMMIT;