#!/usr/bin/env bash

set -e

if [ "$MODE" = "debug" ]; then
  set -x
fi

func_docker_openssl() {
  docker run -i --rm \
    -v /dev/urandom:/dev/random \
    -v /opt/moxa/dlm:/opt/moxa/dlm:rw \
    -v "${USER_DATA_DIR}:${USER_DATA_DIR}:rw" \
    --user root \
    -w /opt/moxa/dlm \
    ${REGISTRY_HOST}/openssl:${OPENSSL_VERSION} "$@"
}

source_environment_variables() {
  # get the directory of the script
  install_dir=$(dirname "$(dirname "$(readlink -f "$0")")")
  export install_dir
  if [ -f "${install_dir}/static-config/env-files/manifest.env" ]; then
    # shellcheck disable=SC2046
    export $(grep -v '^#' "${install_dir}/static-config/env-files/manifest.env" | xargs)
  fi
  if [ -f "${USER_DATA_DIR}/env-files/global.env" ]; then
    # shellcheck disable=SC2046
    export $(grep -v '^#' "${USER_DATA_DIR}/env-files/global.env" | xargs)
  fi
}

up() {
  echo "Generate JWT Secrets..."
  jwt_secret=$(/opt/moxa/dlm/bin/dlm config global JWT_SECRET)
  if [ -z "$jwt_secret" ]; then
    /opt/moxa/dlm/bin/dlm config global JWT_SECRET "$(func_docker_openssl rand -hex 32)"
  fi
  if [ "$jwt_secret" = "This-Is-DEV-USEONLY-JWT_SECRET" ]; then
    /opt/moxa/dlm/bin/dlm config global JWT_SECRET "$(func_docker_openssl rand -hex 32)"
  fi
}

down() {
  # shellcheck disable=SC1091
  source "${USER_DATA_DIR}/env-files/global.env"

  echo "Remove JWT Secrets..."
  /opt/moxa/dlm/bin/dlm config global JWT_SECRET "This-Is-DEV-USEONLY-JWT_SECRET"
}

main() {
  arg1=${1:-usage}

  case $arg1 in
  up)
    up
    ;;
  down)
    down
    ;;
  *)
    echo "Usage: $0 {up|down}"
    exit 1
    ;;
  esac
}

source_environment_variables
main "$@"
