#!/bin/bash
#
# SPDX-License-Identifier: Apache-2.0
#
# Description: Set Moxa default hostname
#

arch="$(uname -m)"
serialnumber=""
hostname_file="/etc/hostname"
hosts_file="/etc/hosts"
flagfilepath="/etc/moxa-mil-base-system/.moxa-hostname"

if [ "${arch}" == "armv7l" ] || [ "${arch}" == "aarch64" ]; then
	serialnumber="$(fw_printenv -n serialnumber)"
elif [ "${arch}" == "x86_64" ]; then
	serialnumber="$(cat /sys/class/dmi/id/board_serial)"
fi

# if flag file is not existed, reset hosts and hostname, and create flag file
if [ ! -f ${flagfilepath} ]; then
	echo "moxa-${serialnumber,,}" > "/proc/sys/kernel/hostname"
	echo "moxa-${serialnumber,,}" > "${hostname_file}"
	cat > "${hosts_file}" << EOF
127.0.0.1 localhost
127.0.1.1 moxa-${serialnumber,,}
::1 moxa-${serialnumber,,}

# The following lines are desirable for IPv6 capable hosts
::1 localhost ip6-localhost ip6-loopback
ff02::1 ip6-allnodes
ff02::2 ip6-allrouters
EOF
	touch ${flagfilepath}
else
	# update hosts and hostname files if device's serial number was changed
	if ! grep -r -q "moxa-${serialnumber}" "${hostname_file}"; then
		echo "moxa-${serialnumber,,}" > "${hostname_file}"
	fi
	
	if ! grep -r -q "127.0.1.1 moxa-${serialnumber,,}" "${hosts_file}"; then
		sed -i "s/127.0.1.1.*moxa-.*/127.0.1.1 moxa-${serialnumber,,}/g" "${hosts_file}"
	fi
	
	if ! grep -r -q "::1 moxa-${serialnumber,,}" "${hosts_file}"; then
		sed -i "s/::1.*moxa-.*/::1 moxa-${serialnumber,,}/g" "${hosts_file}"
	fi
fi

sync
