# moxa-sdhci-pci-driver
## Description
On Debian 11, if the SD host controller communicates with the CPU via SDIO, it would not initialize successfully.

## Envirnoment
- OS: Debian 11 (kernel 5.10)
- Model: BXP-A100, MPC-3000

## Symptom
- dmesg log

`sdhci-pci` driver try to initialize SD host controller several times but failed.

```
[16172.574123] sdhci: Secure Digital Host Controller Interface driver
[16172.574126] sdhci: Copyright(c) Pierre Ossman
[16172.589386] sdhci-pci 0000:00:1a.0: SDHCI controller found [8086:4b47] (rev 11)
[16172.608531] sdhci-pci 0000:00:1a.1: SDHCI controller found [8086:4b48] (rev 11)
[20512.185273] sdhci-pci 0000:00:1a.1: SDHCI controller found [8086:4b48] (rev 11)
[20513.157678] sdhci-pci 0000:00:1a.1: SDHCI controller found [8086:4b48] (rev 11)
[20513.225701] sdhci-pci 0000:00:1a.1: SDHCI controller found [8086:4b48] (rev 11)
```

- SD host controller does not be established. Only eMMC host controller is established.

```
# ls -l /sys/class/mmc_host/mmc*
lrwxrwxrwx 1 root root 0 Nov 30 11:03 /sys/class/mmc_host/mmc0 -> ../../devices/pci0000:00/0000:00:1a.0/mmc_host/mmc0
```

## Root cause
- In driver probe phase, when probe card detect gpio failed (EPROBE_DEFER), it would release SD host controller resources.

```c
static struct sdhci_pci_slot *sdhci_pci_probe_slot(...)
{
        ...
        ...
        if (slot->cd_idx >= 0) {
	        ret = mmc_gpiod_request_cd(host->mmc, "cd", slot->cd_idx,
	        			   slot->cd_override_level, 0);
	        if (ret && ret != -EPROBE_DEFER)
	        	ret = mmc_gpiod_request_cd(host->mmc, NULL,
	        				   slot->cd_idx,
	        				   slot->cd_override_level,
	        				   0);
	        if (ret == -EPROBE_DEFER)
	        	goto remove;

	        if (ret) {
	        	dev_warn(&pdev->dev, "failed to setup card detect gpio\n");
	        	slot->cd_idx = -1;
	        }
        }
        ...
        ...
}
```

## Solve it
- Pass module parameter (`enable_probe_cd_gpio`) to determine probe card detect gpio or not.

```
# modprobe sdhci_pci enable_probe_cd_gpio=0
```
```
# dmesg
[83967.247209] sdhci: Secure Digital Host Controller Interface driver
[83967.247212] sdhci: Copyright(c) Pierre Ossman
[83967.249643] sdhci-pci 0000:00:1a.0: SDHCI controller found [8086:4b47] (rev 11)
[83967.250181] sdhci-pci 0000:00:1a.0: disable card detect gpio from setup
[83967.250229] mmc0: CQHCI version 5.10
[83967.250363] mmc0: SDHCI controller on PCI [0000:00:1a.0] using ADMA 64-bit
[83967.250390] sdhci-pci 0000:00:1a.1: SDHCI controller found [8086:4b48] (rev 11)
[83967.251508] sdhci-pci 0000:00:1a.1: disable card detect gpio from setup
```
```
# ls -l  /sys/class/mmc_host/mmc*
lrwxrwxrwx 1 root root 0 Nov 30 11:08 /sys/class/mmc_host/mmc0 -> ../../devices/pci0000:00/0000:00:1a.0/mmc_host/mmc0
lrwxrwxrwx 1 root root 0 Nov 30 11:08 /sys/class/mmc_host/mmc1 -> ../../devices/pci0000:00/0000:00:1a.1/mmc_host/mmc1
```

- Load module parameter on system startup
  1. Add configuration file to /lib/modprobe.d/sdhci-pci-option.conf
  ```
  options sdhci-pci enable_probe_cd_gpio=0
  ```
  2. Update init file system
  ```
  # update-initramfs -u -k $(uname -r)
  ```

