/*
 * Copyright (C) MOXA Inc. All rights reserved.
 * Authors:
 *     2024  Wilson YS Huang  <wilsonys.huang@moxa.com>
 * This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
 * See the file LICENSE for details.
 */

#include <logger.h>

static int32_t current_log_level;

int32_t logger_get_level()
{
    return current_log_level;
}

void logger_set_level(int32_t level)
{
    current_log_level = level;
    setlogmask(LOG_UPTO(current_log_level));
}

void logger_init(const char *ident)
{
    openlog(ident, LOG_CONS | LOG_PID | LOG_NDELAY, LOG_DAEMON);
    logger_set_level(DEFAULT_LOG_LEVEL);
}

void logger_shutdown(void)
{
    closelog();
}
