# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [1.2.1] - 2025-06-25
### Fixed
* Systemd service run as root privileged user in group

## [1.2.0] - 2025-06-10
### Added
* Add new MCU command
    - Get model name
    - Control brightness
    - Get system status
    - Enable/Disable touch panel
    - Show/hide on-screen display
* Support MPC-3000 series

### Changed
* Expand feature capacity in struct by changing member type
* Rename app watchdog option function name

### Fixed
* Check model initial callback is defined before execute

### Removed
* Remove 'name_prefix_sz' in model information


## [1.1.0] - 2025-04-02
### Added
* Support long options
* Add testcases for long options

## [1.0.0] - 2025-02-10
### Added
* Support MCU firmware upgrade
* Add command pre callback function
* Enhance unix client handling
* Add test script

### Removed
* Remove compatible script wrapper

## [0.5.0] - 2025-02-05
### Added
* Add proxy queue to handle MCU requests and responses safely

## [0.4.1] - 2024-12-10
## Fixed
* Update proper version

## [0.4.0] - 2024-11-18
### Removed
* Remove watchdog reset control and app watchdog reset control

### Fixed
* Correct typo

## [0.3.0] - 2024-10-08
### Added
* Get/Set app watchdog timeout

### Fixed
* Ensure buffer has a null terminator after reading the GPIO value to prevent undefined behavior
* Correct debian package information
* Make mx-mcu-mgmt return code properly

## [0.2.0] - 2024-09-25
### Added
* Get model name by dmidecode tool
* Toggle debug log via signal SIGHUP
* Support V3400 series
* Handle SIGINT or SIGTERM signal when daemon shutdown
* Check MCU is available or not on V3200 and V3400
* Add compatible script wrapper

## Fixed
* Add stack protect CFLAGS and prevent stackoverflow
* Show error log if MCU daemon is not available

## [0.1.0] - 2024-09-04
### Added
* Create a proxy daemon 'mx-mcud' to handle command from command utility 'mx-mcu-mgmt' to tty device.
* Support MCU features
    - Get MCU firmware version
    - Control relay mode
    - Control watchdog reset mode
    - Control watchdog relay mode
    - Control power off (S5) relay mode
    - Control app watchdog reset mode
    - Control app watchdog relay mode
* Support V3200 series.
