#!/bin/bash

MCU_TOOL="mx-mcu-mgmt"
MCU_FW_VERSION="1.0.0[S00]"

print_result() {
    if [ $1 -eq 0 ]; then
        printf "\r[\e[32mPASS\e[0m] $2\n"
    else
        printf "\r[\e[31mFAIL\e[0m] $2\n"
    fi
}

run_test() {
    printf "[TEST] $1"
    output=$($1 2>&1)
    ret=$?
    expect=$2

    if [ "$ret" -eq 0 ] && ( [ "$output" == "$expect" ] || [ -z "$expect" ] ); then
        print_result 0 "$1"
    else
        print_result 1 "$1"
    fi
}

run_test "$MCU_TOOL -v"
run_test "$MCU_TOOL --version"
run_test "$MCU_TOOL -h"
run_test "$MCU_TOOL --help"

run_test "$MCU_TOOL mcu_version" "$MCU_FW_VERSION"
run_test "$MCU_TOOL model_name" "MPC-3000_SERIES"

run_test "$MCU_TOOL brightness set_level 0"
run_test "$MCU_TOOL brightness get_level" "0"
run_test "$MCU_TOOL brightness set_level 1"
run_test "$MCU_TOOL brightness get_level" "1"
run_test "$MCU_TOOL brightness set_level 2"
run_test "$MCU_TOOL brightness get_level" "2"
run_test "$MCU_TOOL brightness set_level 3"
run_test "$MCU_TOOL brightness get_level" "3"
run_test "$MCU_TOOL brightness set_level 4"
run_test "$MCU_TOOL brightness get_level" "4"
run_test "$MCU_TOOL brightness set_level 5"
run_test "$MCU_TOOL brightness get_level" "5"
run_test "$MCU_TOOL brightness set_level 6"
run_test "$MCU_TOOL brightness get_level" "6"
run_test "$MCU_TOOL brightness set_level 7"
run_test "$MCU_TOOL brightness get_level" "7"
run_test "$MCU_TOOL brightness set_level 8"
run_test "$MCU_TOOL brightness get_level" "8"
run_test "$MCU_TOOL brightness set_level 9"
run_test "$MCU_TOOL brightness get_level" "9"
run_test "$MCU_TOOL brightness set_level 10"
run_test "$MCU_TOOL brightness get_level" "10"

run_test "$MCU_TOOL system_status get_backlight"
run_test "$MCU_TOOL system_status get_display"

run_test "$MCU_TOOL touch_panel enable"
run_test "$MCU_TOOL touch_panel status" "enable"
run_test "$MCU_TOOL touch_panel disable"
run_test "$MCU_TOOL touch_panel status" "disable"

run_test "$MCU_TOOL osd show"
run_test "$MCU_TOOL osd status" "show"
run_test "$MCU_TOOL osd hide"
run_test "$MCU_TOOL osd status" "hide"