#!/bin/bash
#
# Copyright (C) 2024 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2024  Wilson YS Huang  <wilsonys.huang@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
source "${INSTL_SCRIPT_DIR}/lib/colors.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

main() {
        if util::is_exists "/usr/sbin/watchdog"; then
                if systemctl is-active watchdog >/dev/null 2>&1; then
                        log::info "$(printf " %-50s$(colors::green %-15s)$(colors::green %-25s)\n" "- watchdog service" "Yes" "Active")"
                else
                        log::info "$(printf " %-50s$(colors::green %-15s)$(colors::red %-25s)\n" "- watchdog service" "Yes" "Inactive")"
                fi
        else
                log::info "$(printf " %-50s$(colors::red %-15s)%-25s\n" "- watchdog service" "No" "N/A")"
        fi
}

main "$@"
