#!/bin/bash
#
# Copyright (C) 2024 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2024  Wilson YS Huang  <wilsonys.huang@moxa.com>

MOXA_VERSION_CONF_FILE="/etc/moxa-version.conf"

help_page() {
        cat <<EOF
Usage: mx-ver [option]

Options:
        -a: show all information
        -m: show product name
        -o: show option code
        -v: show SDK version
        -b: show SDK build date
        -k: show installed kernel version
        -V: show CTOS version
        -B: show CTOS build date
        -h: show the help page
EOF
}

read_info() {
        local option=$1

        awk -v opt="${option}" -F= '$1==opt { print $2 ;}' ${MOXA_VERSION_CONF_FILE} |
                tr -d '"'
}

main() {
        local param

        if [[ ! -e "${MOXA_VERSION_CONF_FILE}" ]]; then
                echo "Error: Can't not load version configuration file."
                exit 1
        fi

        param="$1"
        case "$param" in
        -h)
                help_page
                exit 0
                ;;
        -a) cat "${MOXA_VERSION_CONF_FILE}" ;;
        -m) read_info "PRODUCT_NAME" ;;
        -o) read_info "OPTION_CODE" ;;
        -v) read_info "SDK_VERSION" ;;
        -b) read_info "SDK_BUILDDATE" ;;
        -k) read_info "KERNEL_VERSION" ;;
        -V) read_info "IMAGE_VERSION" ;;
        -B) read_info "IMAGE_BUILDDATE" ;;
        *)
                echo "Invalid option was provided: $param"
                help_page
                exit 22
                ;;
        esac
}

main "$@"
