#!/bin/bash
#
# Copyright (C) 2024 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2024  Elvis Yao  <elviscw.yao@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

REPO_NAME="moxa-app-wdt-utility"
SRC_PATH_PREFIX="${INSTL_TOP_DIR}/src/${REPO_NAME}"

main() {
        local src_tag
        local src_ver
        src_tag="$1"
        src_ver="$2"

        log::info "Installing ${REPO_NAME} (${src_ver})" && false

        {
                pushd "${SRC_PATH_PREFIX}-${src_tag}" >/dev/null

                make clean
                make MCU_DEVICE="${CFG_MCU_DEVICE}"
                make install

                cp mx-app-wdtd.service /lib/systemd/system/
                cp mx-disable-app-wdt.service /lib/systemd/system/
                systemctl enable mx-app-wdtd.service
                systemctl enable mx-disable-app-wdt.service
                systemctl start mx-app-wdtd.service
                systemctl start mx-disable-app-wdt.service

                popd
        } >>"${INSTL_LOG_FILE}" 2>&1
}

main "$@"
