/**
 * @file mcm-listen-event.h
 *
 * This library is for Moxa Connection Management
 *
 * @author York LY Chang <YorkLY.Chang@moxa.com>
 */
#ifndef _MCM_LISTEN_EVENT_H_
#define _MCM_LISTEN_EVENT_H_
#include "mcm-base-info.h"
typedef struct event_context event_context;

/**
 * @brief A help function for init properties changed event context .
 *
 * @return Return properties changed event context .
 *
 */
event_context *
mcm_init_property_changed_event_context();

/**
 * @brief A help function for free properties changed event context .
 *
 * @param context (input) Properties changed event context .
 *
 */
void mcm_free_property_changed_event_context(event_context *context);

/**
 * @brief A help function for subscribe properties changed.
 *
 * @param interface_name [in] Interfaces name.
 *
 * @param context [out] Properties changed event context .
 *
 * @param callback [in] A callback function when property changed.
 *
 * @param interface_name [in] Changed property interface name.
 *
 * @param property_name [in] Changed property property name.
 *
 * @param property_value [in] Changed property property value.
 *
 * @return If subscribe properties changed success return 0. If fail, return error number.
 */
int mcm_subscribe_properties_changed_interface(char *interface_name, event_context *context, int (*callback)(const char *interface_name, const char *property_name, const char *property_value));

/**
 * @brief A help function for subscribe properties changed.
 *
 *
 * @param context [out] Properties changed event context .
 *
 * @param callback [in] A callback function when property changed.
 *
 *
 * @param property_name [in] Changed property property name.
 *
 * @param property_value [in] Changed property property value.
 *
 * @return If subscribe properties changed success return 0. If fail, return error number.
 */
int mcm_subscribe_properties_changed_wan(event_context *context, int (*callback)(const char *property_name, const char *property_value));

/**
 * @brief A help function for subscribe properties changed.
 *
 * @param interface_name [in] Changed property interface name.
 *
 * @param context [out] Properties changed event context .
 *
 * @param callback [in] A callback function when property changed.
 *
 * @param received_prop [in] Notify received PropertiesChange Signal.
 *
 *
 * @return If subscribe properties changed success return 0. If fail, return error number.
 */
int mcm_subscribe_properties_changed_notify_interface(char *interface_name, event_context *context, int (*callback)(int *received_prop));

/**
 * @brief A help function for get all ethernet properties.
 *
 * @param context [in] Properties changed event context.
 *
 * @return If start properties changed success return 0.If fail, return error number.
 */
int mcm_start_listen_subscribe_properties_changed_event(event_context *context);

/**
 * @brief A help function for get all ethernet properties.
 *
 * @param context [in] Properties changed event context.
 *
 * @return If stop properties changed success return 0.If fail, return error number.
 */
int mcm_stop_listen_subscribe_properties_changed_event(event_context *context);

#endif /* _MCM_LISTEN_EVENT_H_ */
