/**
 * @file mcm-datausage.h
 *
 * This library is for Moxa Connection Management
 *
 */
#ifndef _MCM_DATAUSAGE_H_
#define _MCM_DATAUSAGE_H_
#include "mcm-base-info.h"
/**
 * @brief A helper function to get traffic.
 *
 * @param interfaceName (input) Interface name.
 *
 * @param traffic_info (output) A datausage infomation structure.
 *
 * @return If get total traffic success return 0. If fail, return error number.
 *
 */
int mcm_datausage_get_iface_total(char *interfaceName, mcm_datausage_info *traffic_info);

/**
 * @brief A helper function to get traffic for a period of time.
 *
 * @param interfaceName (input) Interface name.
 *
 * @param databegin (input) Start date. expected date format YYYY-MM-DD HH:MM or YYYY-MM-DD.
 *
 * @param dataend (input) End date. expected date format YYYY-MM-DD HH:MM or YYYY-MM-DD.
 *
 * @param traffic_info (output) A datausage infomation structure.
 *
 * @return If get total traffic success return 0. If fail, return error number.
 *
 */
int mcm_datausage_get_iface_period(char *interfaceName, char *databegin, char *dataend, mcm_datausage_info *traffic_info);

/**
 * @brief A helper function to get traffic for a period of time.
 *
 * @param interfaceName (input) Interface name.
 *
 * @param databegin (input) Start date. expected date format YYYY-MM-DD HH:MM or YYYY-MM-DD.
 *
 * @param traffic_info (output) A datausage infomation structure.
 *
 * @return If get total traffic success return 0. If fail, return error number.
 *
 */
int mcm_datausage_get_iface_from(char *interfaceName, char *databegin, mcm_datausage_info *traffic_info);

/**
 * @brief A helper function to reset traffic data and restart monitor.
 *
 * @return If reset success return 0. If fail, return error number.
 *
 */
int mcm_datausage_reset(char *interfaceName);

#endif
