/*
 * Copyright (C) MOXA Inc. All rights reserved.
 * Authors:
 *     2024  Wilson YS Huang  <wilsonys.huang@moxa.com>
 * This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
 * See the file LICENSE for details.
 */

#ifndef _LOGGER_H_
#define _LOGGER_H_

#include <stdint.h>
#include <syslog.h>

#define log_debug(msg, ...) syslog(LOG_DEBUG, "[DEBUG] " msg, ##__VA_ARGS__)
#define log_info(msg, ...)  syslog(LOG_INFO, "[INFO] " msg, ##__VA_ARGS__)
#define log_warn(msg, ...)  syslog(LOG_WARNING, "[WARNING] " msg, ##__VA_ARGS__)
#define log_error(msg, ...) syslog(LOG_ERR, "[ERROR] " msg, ##__VA_ARGS__)

#define DEFAULT_LOG_LEVEL LOG_INFO

int32_t logger_get_level();
void    logger_set_level(int32_t level);
void    logger_init(const char *ident);
void    logger_shutdown(void);

#endif