/*
 * Copyright (C) MOXA Inc. All rights reserved.
 * Authors:
 *     2024  Wilson YS Huang  <wilsonys.huang@moxa.com>
 * This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
 * See the file LICENSE for details.
 */

#ifndef _SOCKET_H_
#define _SOCKET_H_

#include <stdbool.h>
#include <stdint.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/un.h>

#include <common.h>

#define UNIX_PATH_MAX 108

enum {
    ERR_CODE_OK = 0,
    ERR_CODE_COMMAND_NOT_SUPPORT,
    ERR_CODE_COMMAND_ILLEGAL_MCU_PKT,
    ERR_CODE_COMMAND_NACK_MCU_PKT,
    ERR_CODE_COMMAND_UNEXPECTED_RESP,
    ERR_CODE_MCU_NOT_AVAILABLE,
    ERR_CODE_UNKNOWN
};

typedef struct {
    uint8_t data_sz;
    uint8_t data[MAX_DATA_SZ];
} __attribute__((packed)) socket_payload;

typedef struct {
    uint8_t        command[3];
    socket_payload payload;
} __attribute__((packed)) socket_request_packet;
typedef struct {
    int8_t         return_code;
    socket_payload payload;
} __attribute__((packed)) socket_response_packet;

const char *get_error_string(uint8_t err);
bool        is_valid_fd(int32_t fd);
void        close_fd(int32_t fd);
int32_t     create_unix_socket(struct sockaddr_un *addr_un, const char *unix_path);
int32_t     create_unix_skt_client(const char *unix_server_path);
int32_t     create_unix_skt_server(const char *unix_path);
size_t      make_socket_packet(socket_request_packet *skt_pkt, char command[3], uint8_t *data, size_t data_sz);

#endif