#!/bin/bash
#
# Copyright (C) 2024 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#
# Authors:
#       2024  Elvis Yao  <ElvisCW.Yao@moxa.com>

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

set -e

main() {
        if util::is_exists "/usr/sbin/mx-mcu-mgmt"; then
                log::info "$(printf " %-30s$(colors::green %-15s)$(colors::green %-25s)\n" "- mx-mcu-mgmt" "Yes" "Active")"
        else
                log::info "$(printf " %-30s$(colors::red %-15s)%-25s\n" "- mx-mcu-mgmt" "No" "N/A")"
        fi
}

main "$@"
