/*
	Copyright (C) MOXA Inc. All rights reserved.

	This software is distributed under the terms of the
	MOXA License.  See the file COPYING-MOXA for details.
*/
#pragma once
#include <iostream>
#include <string>
using namespace std;

#ifdef __cplusplus    // If used by C++ code, 
extern "C" {          // we need to export the C interface
#endif

	enum DIO_STATUS
	{
		DIO_HIGH = 1,
		DIO_LOW = 0,
		LIB_INITIALIZE_FAIL = -1,
		PORT_OUTOF_INDEX = -2,
		SET_STATUS_ERR = -3
	};

	HMODULE GetCurrentModule();
	HANDLE mxdgio_open();
	void mxdgio_close(HANDLE fd);
	int mxdgio_get_input_signal(HANDLE fd, int port);
	int mxdgio_get_output_signal(HANDLE fd, int port);
	int mxdgio_set_output_signal_low(HANDLE fd, int port);
	int mxdgio_set_output_signal_high(HANDLE fd, int port);

	int InitMXDGIO(void);
	int GetDinStatus(int port);
	int GetDoutStatus(int port);
	int SetDoutStatus(int port, int status);
	int GetDinCount();
	int GetDoutCount();

#ifdef __cplusplus    // If used by C++ code, 
}
#endif