/**
 * @file mcm-control.h
 *
 * This library is for Moxa Connection Management
 *
 */
#ifndef _MCM_CONTROL_H_
#define _MCM_CONTROL_H_

/**
 * @brief A helper function to start MCMD.
 *
 * @return If mcmd start success return 0. If fail, return error number.
 *
 */
int mcm_control_start(void);

/**
 * @brief A helper function to stop MCMD.
 *
 * @return If mcmd stop success return 0. If fail, return error number.
 *
 */
int mcm_control_stop(void);

/**
 * @brief A helper function to reload configure files.
 *
 * @return If mcmd reload success return 0. If fail, return error number.
 *
 */
int mcm_control_reload(void);

/**
 * @brief A helper function to stop MCMD.
 *
 * @return If success return MCM state. If fail, return NULL.
 *
 */
const char *
mcm_control_get_state(void);

/**
 * @brief A helper function to reset factory configure files.
 *
 * @return If mcmd reset factory success return 0. If fail, return error number.
 *
 */
int mcm_control_reset_factory(void);

/**
 * @brief A helper function to reset interface configure files.
 *
 * @return If mcmd reset factory success return 0. If fail, return error number.
 *
 */
int mcm_control_reset_interface_factory(const char *interface_name);

#endif
