/*
 * Copyright (C) MOXA Inc. All rights reserved.
 * Authors:
 *     2024  Wilson YS Huang  <wilsonys.huang@moxa.com>
 * This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
 * See the file LICENSE for details.
 */

#ifndef _COMMON_H_
#define _COMMON_H_

#include <stdbool.h>
#include <stdint.h>

#define MOXA_COLOR_FG        "\033[38;2;3;120;124m"
#define MOXA_COLOR_BG        "\033[48;2;3;120;124m"
#define WHITE_COLOR_FB       "\033[97m"
#define RESET_COLOR          "\033[0m"
#define BIT(nr)              (1 << (nr))
#define MAX_DATA_SZ          150
#define COUNT_OF_POLLFD(fds) (sizeof(fds) / sizeof(struct pollfd))

#define IT87_GPIO_MAPPING(gpio_num)  \
    ({                               \
        int _num  = gpio_num;        \
        int group = (_num / 10 - 1); \
        int bit   = _num % 10;       \
        (int)(8 * group + bit);      \
    })

void sleep_ms(int32_t milliseconds);
bool get_sysfs_dmi_value(const char *attribute, char *buffer);
bool execute_pipeline(char **commands[], int num_commands, char *output_buff);
bool get_gpio_value(int32_t gpio, int32_t *value);
bool get_gpio_base_by_label(const char *target_label, int32_t *gpio_base);

#endif