#!/bin/bash -e
#
# Copyright (C) 2024 MOXA Inc. All rights reserved.
# This software is distributed under the terms of the MOXA SOFTWARE NOTICE.
# See the file LICENSE for details.
#

set -e

source "${INSTL_SCRIPT_DIR}/lib/util.sh"
source "${INSTL_SCRIPT_DIR}/lib/logger.sh"
log::init "${INSTL_LOG_FILE}" "${INSTL_LOG_LEVEL}"

main() {
        log::info "Remove Product configs"
        if util::is_exists "/etc/udev/rules.d/99-moxa-x86-serial-naming.rules"; then
                rm -f /etc/udev/rules.d/99-moxa-x86-serial-naming.rules
                {
                        udevadm control --reload-rules
                        udevadm trigger
                } >>"${INSTL_LOG_FILE}"
        fi

        if util::is_exists "/usr/lib/modules-load.d/gpio-pca953x.conf"; then
                rm -f /usr/lib/modules-load.d/gpio-pca953x.conf
        fi

        if util::is_exists "/usr/lib/modules-load.d/hid_ft260.conf"; then
                rm -f /usr/lib/modules-load.d/hid_ft260.conf
        fi

        if util::is_exists "/etc/udev/rules.d/11-ft260-pca9535.rules"; then
                rm -f /etc/udev/rules.d/11-ft260-pca9535.rules
        fi

        if util::is_exists "/etc/udev/rules.d/12-ft260-systemd.rules"; then
                rm -f /etc/udev/rules.d/12-ft260-systemd.rules
        fi

        if util::is_exists "/lib/modules-load.d/it87.conf"; then
                rm -f /lib/modules-load.d/it87.conf
        fi

        if util::is_exists "/etc/sensors.d/it8786.conf"; then
                rm -f /etc/sensors.d/it8786.conf
        fi

        if util::is_exists "/lib/systemd/system/da820e_init.service"; then
                {
                        systemctl daemon-reload
                        systemctl disable da820e_init
                } >>"${INSTL_LOG_FILE}"
                rm -f /lib/systemd/system/da820e_init.service
        fi

        if util::is_exists "/sbin/da820e_init"; then
                rm -f /sbin/da820e_init
        fi

}

main
